/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.VisualIDHolder;
import jogamp.nativewindow.x11.XVisualInfo;

public class X11Capabilities
extends Capabilities {
    private final XVisualInfo xVisualInfo;

    public X11Capabilities(XVisualInfo xVisualInfo) {
        this.xVisualInfo = xVisualInfo;
    }

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (RuntimeException runtimeException) {
            throw new NativeWindowException(runtimeException);
        }
    }

    public final XVisualInfo getXVisualInfo() {
        return this.xVisualInfo;
    }

    public final int getXVisualID() {
        return null != this.xVisualInfo ? (int)this.xVisualInfo.getVisualid() : 0;
    }

    public final boolean hasXVisualInfo() {
        return null != this.xVisualInfo;
    }

    @Override
    public final int getVisualID(VisualIDHolder.VIDType vIDType) throws NativeWindowException {
        switch (vIDType) {
            case INTRINSIC: 
            case NATIVE: 
            case X11_XVISUAL: {
                return this.getXVisualID();
            }
            case X11_FBCONFIG: {
                return 0;
            }
        }
        throw new NativeWindowException("Invalid type <" + (Object)((Object)vIDType) + ">");
    }

    @Override
    public StringBuffer toString(StringBuffer stringBuffer) {
        if (null == stringBuffer) {
            stringBuffer = new StringBuffer();
        }
        stringBuffer.append("x11 vid ");
        if (this.hasXVisualInfo()) {
            stringBuffer.append("0x").append(Long.toHexString(this.xVisualInfo.getVisualid()));
        } else {
            stringBuffer.append("----");
        }
        stringBuffer.append(": ");
        return super.toString(stringBuffer);
    }
}

