/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLDisplayUtil;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGLCapabilities;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;

public abstract class EGLDrawable
extends GLDrawableImpl {
    protected boolean ownEGLDisplay = false;
    protected boolean ownEGLSurface = false;
    private EGLGraphicsConfiguration eglConfig;
    protected long eglDisplay = 0L;
    protected long eglSurface = 0L;

    protected EGLDrawable(EGLDrawableFactory eGLDrawableFactory, NativeSurface nativeSurface) throws GLException {
        super(eGLDrawableFactory, nativeSurface, false);
    }

    public long getDisplay() {
        return this.eglDisplay;
    }

    @Override
    public long getHandle() {
        return this.eglSurface;
    }

    public EGLGraphicsConfiguration getGraphicsConfiguration() {
        return this.eglConfig;
    }

    @Override
    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        return null == this.eglConfig ? super.getChosenGLCapabilities() : (GLCapabilitiesImmutable)this.eglConfig.getChosenCapabilities();
    }

    @Override
    public abstract GLContext createContext(GLContext var1);

    protected abstract long createSurface(long var1, long var3, long var5);

    private void recreateSurface() {
        NativeWindow nativeWindow;
        int n;
        if (0L != this.eglSurface) {
            EGL.eglDestroySurface(this.eglDisplay, this.eglSurface);
        }
        if (DEBUG) {
            System.err.println(EGLDrawable.getThreadName() + ": createSurface using eglDisplay " + EGLDrawable.toHexString(this.eglDisplay) + ", " + this.eglConfig);
        }
        this.eglSurface = this.createSurface(this.eglDisplay, this.eglConfig.getNativeConfig(), this.surface.getSurfaceHandle());
        if (0L == this.eglSurface && 12299 == (n = EGL.eglGetError()) && this.surface instanceof NativeWindow && (nativeWindow = (NativeWindow)this.surface).getWindowHandle() != nativeWindow.getSurfaceHandle()) {
            if (DEBUG) {
                System.err.println(EGLDrawable.getThreadName() + ": Info: Creation of window surface w/ surface handle failed: " + this.eglConfig + ", error " + EGLDrawable.toHexString(n) + ", retry w/ windowHandle");
            }
            this.eglSurface = this.createSurface(this.eglDisplay, this.eglConfig.getNativeConfig(), nativeWindow.getWindowHandle());
        }
        if (0L == this.eglSurface) {
            throw new GLException("Creation of window surface failed: " + this.eglConfig + ", " + this.surface + ", error " + EGLDrawable.toHexString(EGL.eglGetError()));
        }
        if (DEBUG) {
            System.err.println(EGLDrawable.getThreadName() + ": setSurface using component: handle " + EGLDrawable.toHexString(this.surface.getSurfaceHandle()) + " -> " + EGLDrawable.toHexString(this.eglSurface));
        }
    }

    @Override
    protected final void updateHandle() {
        if (this.ownEGLSurface) {
            this.recreateSurface();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setRealizedImpl() {
        if (this.realized) {
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.surface.getGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
            if (abstractGraphicsDevice instanceof EGLGraphicsDevice) {
                if (DEBUG) {
                    System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable.setRealized(true): using existing EGL config - START");
                }
                this.eglDisplay = abstractGraphicsDevice.getHandle();
                if (this.eglDisplay == 0L) {
                    throw new GLException("Invalid EGL display in EGLGraphicsDevice from " + abstractGraphicsDevice);
                }
                if (!(abstractGraphicsConfiguration instanceof EGLGraphicsConfiguration)) throw new GLException("EGLGraphicsDevice hold by non EGLGraphicsConfiguration: " + abstractGraphicsConfiguration);
                this.eglConfig = (EGLGraphicsConfiguration)abstractGraphicsConfiguration;
                if (null == this.eglConfig) {
                    throw new GLException("Null EGLGraphicsConfiguration from " + abstractGraphicsConfiguration);
                }
                int[] nArray = new int[1];
                if (0L != this.surface.getSurfaceHandle() && EGL.eglQuerySurface(this.eglDisplay, this.surface.getSurfaceHandle(), 12328, nArray, 0)) {
                    this.eglSurface = this.surface.getSurfaceHandle();
                    if (DEBUG) {
                        System.err.println(EGLDrawable.getThreadName() + ": setSurface re-using component's EGLSurface: handle " + EGLDrawable.toHexString(this.eglSurface));
                    }
                } else {
                    this.ownEGLSurface = true;
                }
            } else {
                if (DEBUG) {
                    System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable.setRealized(true): creating new EGL config - START");
                }
                this.ownEGLDisplay = true;
                this.ownEGLSurface = true;
                this.eglDisplay = EGLDisplayUtil.eglGetDisplay(this.surface, true);
                if (this.eglDisplay == 0L) {
                    throw new GLException("Failed to created EGL display: " + this.surface + ", " + abstractGraphicsDevice + ", error " + EGLDrawable.toHexString(EGL.eglGetError()));
                }
                if (!EGLDisplayUtil.eglInitialize(this.eglDisplay, null, null)) {
                    throw new GLException("eglInitialize failed, error " + Integer.toHexString(EGL.eglGetError()));
                }
                EGLGraphicsDevice eGLGraphicsDevice = new EGLGraphicsDevice(this.eglDisplay, "decon", 0);
                DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen(eGLGraphicsDevice, abstractGraphicsConfiguration.getScreen().getIndex());
                GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getRequestedCapabilities();
                if (abstractGraphicsConfiguration instanceof EGLGraphicsConfiguration) {
                    this.eglConfig = new EGLGraphicsConfiguration(defaultGraphicsScreen, (EGLGLCapabilities)abstractGraphicsConfiguration.getChosenCapabilities(), gLCapabilitiesImmutable, null);
                    if (DEBUG) {
                        System.err.println(EGLDrawable.getThreadName() + ": Reusing chosenCaps: " + this.eglConfig);
                    }
                } else {
                    this.eglConfig = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, null, defaultGraphicsScreen, abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE));
                    if (null == this.eglConfig) {
                        throw new GLException("Couldn't create EGLGraphicsConfiguration from " + defaultGraphicsScreen);
                    }
                    if (DEBUG) {
                        System.err.println(EGLDrawable.getThreadName() + ": Chosen eglConfig: " + this.eglConfig);
                    }
                }
            }
            if (!DEBUG) return;
            System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable.setRealized(true): END: ownDisplay " + this.ownEGLDisplay + ", ownSurface " + this.ownEGLSurface);
            return;
        } else {
            if (!this.ownEGLSurface || this.eglSurface == 0L) return;
            if (DEBUG) {
                System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable.setRealized(false): ownDisplay " + this.ownEGLDisplay + ", ownSurface " + this.ownEGLSurface + ", eglDisplay: " + EGLDrawable.toHexString(this.eglDisplay) + ", eglSurface: " + EGLDrawable.toHexString(this.eglSurface));
            }
            if (!EGL.eglDestroySurface(this.eglDisplay, this.eglSurface)) {
                throw new GLException("Error destroying window surface (eglDestroySurface)");
            }
            this.eglSurface = 0L;
            if (this.ownEGLDisplay && 0L != this.eglDisplay) {
                EGLDisplayUtil.eglTerminate(this.eglDisplay);
            }
            this.eglDisplay = 0L;
            this.eglConfig = null;
        }
    }

    @Override
    protected final void swapBuffersImpl() {
        if (!EGL.eglSwapBuffers(this.eglDisplay, this.eglSurface)) {
            throw new GLException("Error swapping buffers, eglError " + EGLDrawable.toHexString(EGL.eglGetError()) + ", " + this);
        }
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper() {
        if (this.getGLProfile().usesNativeGLES2()) {
            return this.getFactoryImpl().getGLDynamicLookupHelper(2);
        }
        if (this.getGLProfile().usesNativeGLES1()) {
            return this.getFactoryImpl().getGLDynamicLookupHelper(1);
        }
        throw new GLException("Unsupported: " + this.getGLProfile());
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[realized " + this.isRealized() + ",\n\tfactory    " + this.getFactory() + ",\n\tsurface    " + this.getNativeSurface() + ",\n\teglSurface " + EGLDrawable.toHexString(this.eglSurface) + ",\n\teglConfig  " + this.eglConfig + ",\n\trequested  " + this.getRequestedGLCapabilities() + ",\n\tchosen     " + this.getChosenGLCapabilities() + "]";
    }
}

