/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.animation;

import madparker.gametools.util.Timer;
import processing.core.PApplet;

public abstract class BackgroundAnimation
extends Timer {
    protected long duration;
    private long progress;
    protected float percent;
    public static final int MODE_LOOP = 0;
    public static final int MODE_PING_PONG = 1;
    public int mode;
    public int dir;

    public void trigger(int mode) {
        super.trigger();
        this.progress = 0L;
        this.percent = 0.0f;
        this.dir = 1;
        this.mode = mode;
    }

    @Override
    public void update() {
        this.progress += this.frameMillis;
        this.percent = this.dir > 0 ? PApplet.map(this.progress, 0.0f, this.duration, 0.0f, 1.0f) : PApplet.map(this.progress, 0.0f, this.duration, 1.0f, 0.0f);
        if (this.percent > 1.0f) {
            this.percent = 1.0f;
        } else if (this.percent < 0.0f) {
            this.percent = 0.0f;
        }
        super.update();
    }

    @Override
    protected void executeEnd() {
        this.percent = 1.0f;
        this.step();
    }

    @Override
    protected boolean isEnd() {
        if (this.progress >= this.duration) {
            if (this.mode == 1) {
                this.dir *= -1;
            }
            this.progress = 0L;
        }
        return false;
    }
}

