/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.screen.sceneGraph;

import java.util.ArrayList;
import java.util.List;
import madparker.gametools.util.GameElement;
import processing.core.PVector;

public class SceneGraphElement
extends GameElement {
    public boolean pause = false;
    public boolean active = true;
    public float scale = 1.0f;
    public float rotate = 0.0f;
    public int color = 0;
    public boolean isAnimElement = false;
    public PVector position = new PVector();
    public List<SceneGraphElement> children = new ArrayList<SceneGraphElement>();
    public List<SceneGraphElement> removeChildren = new ArrayList<SceneGraphElement>();
    public List<SceneGraphElement> addChildren = new ArrayList<SceneGraphElement>();
    public static PVector globalWorldOffset = new PVector();
    public PVector localWorldOffset = new PVector();
    public SceneGraphElement parent;

    public void setupGraph() {
        if (this.active) {
            this.setup();
            for (SceneGraphElement child : this.children) {
                child.setupGraph();
            }
        }
    }

    public void updateGraph() {
        if (!this.pause && this.active) {
            this.update();
            for (SceneGraphElement child : this.children) {
                child.updateGraph();
            }
            this.children.removeAll(this.removeChildren);
            this.children.addAll(this.addChildren);
            this.addChildren.clear();
            this.removeChildren.clear();
        }
    }

    public void displayGraph() {
        if (this.active) {
            pApplet.pushMatrix();
            pApplet.pushStyle();
            pApplet.translate(this.position.x, this.position.y);
            pApplet.scale(this.scale);
            pApplet.rotate(this.rotate);
            this.draw();
            globalWorldOffset.add(this.position);
            this.localWorldOffset.set(SceneGraphElement.globalWorldOffset.x, SceneGraphElement.globalWorldOffset.y, 0.0f);
            for (SceneGraphElement child : this.children) {
                child.parent = this;
                child.displayGraph();
            }
            globalWorldOffset.sub(this.position);
            pApplet.popStyle();
            pApplet.popMatrix();
        }
    }

    public void keyPressedGraph() {
        if (!this.pause && this.active) {
            this.keyPressed();
            for (SceneGraphElement child : this.children) {
                child.keyPressedGraph();
            }
        }
    }

    public void keyReleasedGraph() {
        if (!this.pause && this.active) {
            this.keyReleased();
            for (SceneGraphElement child : this.children) {
                child.keyReleasedGraph();
            }
        }
    }

    public void mousePressedGraph() {
        if (!this.pause && this.active) {
            this.mousePressed();
            for (SceneGraphElement child : this.children) {
                child.mousePressedGraph();
            }
        }
    }

    public void mouseReleasedGraph() {
        if (!this.pause && this.active) {
            this.mouseReleased();
            for (SceneGraphElement child : this.children) {
                child.mouseReleasedGraph();
            }
        }
    }

    public void mouseDraggedGraph() {
        if (!this.pause && this.active) {
            this.mouseDragged();
            for (SceneGraphElement child : this.children) {
                child.mouseDraggedGraph();
            }
        }
    }

    public void animMousePressedGraph() {
        if (!this.pause && this.active) {
            if (this.isAnimElement) {
                this.animMousePressed();
            }
            for (SceneGraphElement child : this.children) {
                child.animMousePressedGraph();
            }
        }
    }

    public void setColor(float r, float g, float b, float a) {
        this.color = pApplet.color(r, g, b, a);
    }

    public void setColor(float r, float g, float b) {
        this.color = pApplet.color(r, g, b);
    }

    public void setColor(int color) {
        this.color = color;
    }
}

