/*
 * Decompiled with CFR 0.152.
 */
package madparker.gametools.util;

import madparker.gametools.util.GameElement;

public abstract class Timer
extends GameElement {
    protected long begin;
    protected long lastCheck;
    public boolean active = false;
    protected long currentTime;
    protected long frameMillis;

    public void trigger() {
        this.active = true;
        this.lastCheck = this.currentTime = (this.begin = (long)pApplet.millis());
        this.frameMillis = 0L;
        this.executeBegin();
    }

    @Override
    public void update() {
        this.currentTime = pApplet.millis();
        this.frameMillis = this.currentTime - this.lastCheck;
        if (this.isEnd()) {
            this.active = false;
            this.executeEnd();
        } else {
            this.step();
        }
        this.lastCheck = this.currentTime;
    }

    public long getElapsed() {
        return this.lastCheck - this.begin;
    }

    protected abstract void executeBegin();

    protected abstract void step();

    protected abstract void executeEnd();

    protected abstract boolean isEnd();

    public long getBegin() {
        return this.begin;
    }

    public boolean isActive() {
        return this.active;
    }

    public void deactivate() {
        this.executeEnd();
        this.active = false;
    }
}

