/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PShape;
import processing.opengl.PGraphics2D;
import processing.opengl.PShapeOpenGL;

public class PShape2D
extends PShapeOpenGL {
    public PShape2D(PApplet parent, int family) {
        super(parent, family);
    }

    @Override
    public boolean is2D() {
        return true;
    }

    @Override
    public boolean is3D() {
        return false;
    }

    public static PShape2D createShape(PApplet parent, PShape src) {
        PShapeOpenGL dest = null;
        if (src.getFamily() == 0) {
            dest = PGraphics2D.createShapeImpl(parent, 0);
            PShape2D.copyGroup(parent, src, dest);
        } else if (src.getFamily() == 1) {
            dest = PGraphics2D.createShapeImpl(parent, src.getKind(), src.getParams());
            PShape.copyPrimitive(src, dest);
        } else if (src.getFamily() == 3) {
            dest = PGraphics2D.createShapeImpl(parent, src.getKind());
            PShape.copyGeometry(src, dest);
        } else if (src.getFamily() == 2) {
            dest = PGraphics2D.createShapeImpl(parent, 2);
            PShape.copyPath(src, dest);
        }
        dest.setName(src.getName());
        return dest;
    }

    public static void copyGroup(PApplet parent, PShape src, PShape dest) {
        PShape2D.copyMatrix(src, dest);
        PShape2D.copyStyles(src, dest);
        PShape2D.copyImage(src, dest);
        for (int i = 0; i < src.getChildCount(); ++i) {
            PShape2D c = PShape2D.createShape(parent, src.getChild(i));
            dest.addChild(c);
        }
    }

    @Override
    public void vertex(float x, float y, float z) {
        PGraphics.showDepthWarningXYZ("vertex");
    }

    @Override
    public void vertex(float x, float y, float z, float u, float v) {
        PGraphics.showDepthWarningXYZ("vertex");
    }

    @Override
    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        PGraphics.showDepthWarningXYZ("bezierVertex");
    }

    @Override
    public void quadraticVertex(float x2, float y2, float z2, float x4, float y4, float z4) {
        PGraphics.showDepthWarningXYZ("quadVertex");
    }

    @Override
    public void curveVertex(float x, float y, float z) {
        PGraphics.showDepthWarningXYZ("curveVertex");
    }

    @Override
    public void translate(float tx, float ty, float tz) {
        PGraphics.showVariationWarning("translate");
    }

    @Override
    public void rotateX(float angle) {
        PGraphics.showDepthWarning("rotateX");
    }

    @Override
    public void rotateY(float angle) {
        PGraphics.showDepthWarning("rotateY");
    }

    @Override
    public void rotateZ(float angle) {
        PGraphics.showDepthWarning("rotateZ");
    }

    @Override
    public void rotate(float angle, float vx, float vy, float vz) {
        PGraphics.showVariationWarning("rotate");
    }

    @Override
    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        PGraphics.showVariationWarning("applyMatrix");
    }

    @Override
    public void scale(float sx, float sy, float sz) {
        PGraphics.showDepthWarningXYZ("scale");
    }

    @Override
    public float getVertexZ(int index) {
        PGraphics.showDepthWarningXYZ("getVertexZ");
        return 0.0f;
    }

    @Override
    public void setVertex(int index, float x, float y) {
        super.setVertex(index, x, y, 0.0f);
    }

    @Override
    public void setVertex(int index, float x, float y, float z) {
        PGraphics.showDepthWarningXYZ("setVertex");
    }
}

