/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import processing.core.PApplet;
import processing.core.PShape;
import processing.opengl.PGraphics3D;
import processing.opengl.PShapeOpenGL;

public class PShape3D
extends PShapeOpenGL {
    public PShape3D(PApplet parent, int family) {
        super(parent, family);
    }

    @Override
    public boolean is2D() {
        return false;
    }

    @Override
    public boolean is3D() {
        return true;
    }

    public static PShape3D createShape(PApplet parent, PShape src) {
        PShapeOpenGL dest = null;
        if (src.getFamily() == 0) {
            dest = PGraphics3D.createShapeImpl(parent, 0);
            PShape3D.copyGroup(parent, src, dest);
        } else if (src.getFamily() == 1) {
            dest = PGraphics3D.createShapeImpl(parent, src.getKind(), src.getParams());
            PShape.copyPrimitive(src, dest);
        } else if (src.getFamily() == 3) {
            dest = PGraphics3D.createShapeImpl(parent, src.getKind());
            PShape.copyGeometry(src, dest);
        } else if (src.getFamily() == 2) {
            dest = PGraphics3D.createShapeImpl(parent, 2);
            PShape.copyPath(src, dest);
        }
        dest.setName(src.getName());
        return dest;
    }

    public static void copyGroup(PApplet parent, PShape src, PShape dest) {
        PShape3D.copyMatrix(src, dest);
        PShape3D.copyStyles(src, dest);
        PShape3D.copyImage(src, dest);
        for (int i = 0; i < src.getChildCount(); ++i) {
            PShape3D c = PShape3D.createShape(parent, src.getChild(i));
            dest.addChild(c);
        }
    }
}

